/*
 * Decompiled with CFR 0.152.
 */
package com.vela.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;

class PluginLogListener
implements ILogListener {
    private List<ILog> logs = new ArrayList<ILog>();
    private PrintStream logFile = null;

    PluginLogListener(String appname) {
        try {
            File outFile;
            String location = System.getProperty("user.home");
            String area = System.getProperty("osgi.instance.area.default");
            if (area != null && !area.isEmpty()) {
                try {
                    URL urlArea = FileLocator.resolve((URL)new URL(area));
                    location = new File(urlArea.toURI()).toString();
                }
                catch (Exception urlArea) {
                    // empty catch block
                }
            }
            if ((outFile = new File(String.valueOf(location) + File.separator + appname + ".log")).exists() && outFile.length() > 0x500000L) {
                Throwable throwable = null;
                Object var6_9 = null;
                try (GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(String.valueOf(outFile.getPath()) + Calendar.getInstance().getTimeInMillis() + ".gz"));){
                    Throwable throwable2 = null;
                    Object var9_14 = null;
                    try (FileInputStream in = new FileInputStream(outFile);){
                        int len;
                        byte[] buffer = new byte[10240];
                        while ((len = in.read(buffer)) != -1) {
                            out.write(buffer, 0, len);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
                outFile.delete();
            }
            this.logFile = new PrintStream(new FileOutputStream(outFile, true));
            System.setOut(this.logFile);
            System.setErr(this.logFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void dispose() {
        Iterator<ILog> i = this.logs.iterator();
        while (i.hasNext()) {
            i.next().removeLogListener((ILogListener)this);
            i.remove();
        }
        if (this.logFile != null) {
            try {
                this.logFile.flush();
                this.logFile.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void logging(IStatus status, String plugin) {
        if (this.logFile == null || status == null) {
            return;
        }
        plugin = PluginLogListener.formatText(plugin);
        String statusPlugin = PluginLogListener.formatText(status.getPlugin());
        String statusMessage = PluginLogListener.formatText(status.getMessage());
        StringBuffer message = new StringBuffer();
        if (plugin != null) {
            message.append(plugin);
            message.append(" - ");
        }
        if (!(statusPlugin == null || plugin != null && statusPlugin.equals(plugin))) {
            message.append(statusPlugin);
            message.append(" - ");
        }
        message.append(status.getCode());
        if (statusMessage != null) {
            message.append(" - ");
            message.append(statusMessage);
        }
        try {
            this.logFile.append(status.getMessage());
            this.logFile.append(message.toString());
            this.logFile.append(status.getException().toString());
            this.logFile.append("\n");
            this.logFile.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String formatText(String text) {
        if (text != null && (text = text.trim()).length() == 0) {
            return null;
        }
        return text;
    }

    public void addLog(ILog log) {
        log.addLogListener((ILogListener)this);
        this.logs.add(log);
    }
}

